; Ring.s : 丸
;


; モジュール宣言
;
    .module Ring

; 参照ファイル
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include    "App.inc"
    .include    "Ring.inc"

; 外部変数宣言
;
    .globl  _rTablePosition
    .globl  _rTableDepth
    .globl  _rTableScale
    .globl  _rTableVector

; マクロの定義
;


; CODE 領域
;
    .area   _CODE

; 丸を初期化する
;
_RingInitialize::

    ; レジスタの保存

    ; フレームの初期化
    xor     a
    ld      (ringFrame), a

    ; レジスタの復帰

    ; 終了
    ret

; 丸を更新する
;
_RingUpdate::

    ; レジスタの保存

    ; フレームの更新
    ld      hl, #ringFrame
    inc     (hl)

    ; レジスタの復帰

    ; 終了
    ret

; 丸を描画する
;
_RingRender::

    ; レジスタの保存

    ; レジスタの復帰

    ; 終了
    ret

; XY 位置を取得する
;
_RingGetLZtoXY::

    ; レジスタの保存
    push    hl
    push    bc

    ; de < Z/L 位置
    ; de > Y/X 位置

    ; 位置の取得
    ld      c, d
    ld      b, #0x00
    ld      hl, #_rTableDepth
    add     hl, bc
    ld      a, (hl)
    or      a
    jr      z, 10$
    dec     a
10$:
    ld      h, a
    ld      l, #0x00
    srl     h
    rr      l
    ld      a, e
    and     #0x3f
    add     a, a
    ld      c, a
    ld      b, #0x00
    add     hl, bc
    ld      bc, #_rTablePosition
    add     hl, bc
    ld      c, (hl)
    inc     hl
    ld      b, (hl)
;   inc     hl
    ld      a, e
    and     #0xc0
    jr      z, 11$
    cp      #0x40
    jr      z, 12$
    cp      #0x80
    jr      z, 13$
    jr      14$
11$:
    ld      a, #0x80
    add     a, c
    ld      e, a
    ld      a, #0x60
    add     a, b
    ld      d, a
    jr      19$
12$:
    ld      a, #0x80
    add     a, b
    ld      e, a
    ld      a, #0x60
    sub     c
    ld      d, a
    jr      19$
13$:
    ld      a, #0x80
    sub     c
    ld      e, a
    ld      a, #0x60
    sub     b
    ld      d, a
    jr      19$
14$:
    ld      a, #0x80
    sub     b
    ld      e, a
    ld      a, #0x60
    add     a, c
    ld      d, a
;   jr      19$
19$:

    ; レジスタの復帰
    pop     bc
    pop     hl

    ; 終了
    ret

; 半径を取得する
;
_RingGetRadius::

    ; レジスタの保存
    push    hl
    push    bc
    push    de

    ; c < Z 位置
    ; b < 半径
    ; a > 半径

    ; スケールの取得
    ld      e, c
    ld      d, #0x00
    ld      hl, #_rTableScale
    add     hl, de
    ld      a, (hl)

    ; 半径の取得
    dec     a
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    dec     b
    add     a, b
    ld      e, a
;   ld      d, #0x00
    ld      hl, #ringRadius
    add     hl, de
    ld      a, (hl)

    ; レジスタの復帰
    pop     de
    pop     bc
    pop     hl

    ; 終了
    ret

; ベクトルを取得する
;
_RingGetVector::

    ; レジスタの保存
    push    hl

    ; a  < 向き
    ; de > ベクトル

    ; ベクトルの取得
    ld      d, #0x00
    add     a, a
    rl      d
    ld      e, a
    ld      hl, #_rTableVector
    add     hl, de
    ld      e, (hl)
    inc     hl
    ld      d, (hl)
;   inc     hl

    ; レジスタの復帰
    pop     hl

    ; 終了
    ret

; 丸を表示する
;
_RingPrintOne::

    ; レジスタの保存
    push    hl
    push    bc

    ; de < スプライト
    ; hl < Y/X 位置
    ; b  < 半径
    ; c  < 色
    ; de > 次のスプライト

    ; スプライトの描画
    push    bc
    push    hl
    ld      a, b
    cp      #0x09
    jr      nc, 10$
    add     a, a
    add     a, a
    ld      c, a
    ld      b, #0x00
    ld      hl, #ringSprite8
    add     hl, bc
    jr      11$
10$:
    sub     #0x09
    add     a, a
    add     a, a
    ld      c, a
    ld      a, (ringFrame)
    and     #0x03
    add     a, c
    add     a, a
    add     a, a
    ld      c, a
    ld      b, #0x00
    ld      hl, #ringSprite16
    add     hl, bc
;   jr      11$
11$:
    pop     bc
    ld      a, (hl)
    add     a, b
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    add     a, c
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    pop     bc
    ld      a, c
    ld      (de), a
;   inc     hl
    inc     de

    ; レジスタの復帰
    pop     bc
    pop     hl

    ; 終了
    ret

_RingPrintAll::

    ; レジスタの保存
    push    hl
    push    bc

    ; de < スプライト
    ; hl < Y/X 位置
    ; b  < 半径
    ; c  < 色
    ; de > 次のスプライト

    ; スプライトの描画
    ld      a, b
    cp      #0x09
    jr      nc, 10$
    push    hl
    push    bc
    add     a, a
    add     a, a
    ld      c, a
    ld      b, #0x00
    ld      hl, #ringSprite8
    add     hl, bc
    pop     bc
    ld      a, c
    pop     bc
    call    11$
    jr      19$
10$:
    push    hl
    push    bc
    sub     #0x09
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    ld      c, a
    ld      b, #0x00
    ld      hl, #ringSprite16
    add     hl, bc
    pop     bc
    ld      a, c
    pop     bc
    call    11$
    call    11$
    call    11$
    call    11$
    jr      19$
11$:
    push    af
    ld      a, (hl)
    add     a, b
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    add     a, c
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    pop     af
    ld      (de), a
    inc     hl
    inc     de
    ret
19$:

    ; レジスタの復帰
    pop     bc
    pop     hl

    ; 終了
    ret

; 定数の定義
;

; 半径
;
ringRadius:

    .db     (0x01 * 0x01 + 0x0f) / 0x10, (0x01 * 0x02 + 0x0f) / 0x10, (0x01 * 0x03 + 0x0f) / 0x10, (0x01 * 0x04 + 0x0f) / 0x10, (0x01 * 0x05 + 0x0f) / 0x10, (0x01 * 0x06 + 0x0f) / 0x10, (0x01 * 0x07 + 0x0f) / 0x10, (0x01 * 0x08 + 0x0f) / 0x10, (0x01 * 0x09 + 0x0f) / 0x10, (0x01 * 0x0a + 0x0f) / 0x10, (0x01 * 0x0b + 0x0f) / 0x10, (0x01 * 0x0c + 0x0f) / 0x10, (0x01 * 0x0d + 0x0f) / 0x10, (0x01 * 0x0e + 0x0f) / 0x10, (0x01 * 0x0f + 0x0f) / 0x10, (0x01 * 0x10 + 0x0f) / 0x10
    .db     (0x02 * 0x01 + 0x0f) / 0x10, (0x02 * 0x02 + 0x0f) / 0x10, (0x02 * 0x03 + 0x0f) / 0x10, (0x02 * 0x04 + 0x0f) / 0x10, (0x02 * 0x05 + 0x0f) / 0x10, (0x02 * 0x06 + 0x0f) / 0x10, (0x02 * 0x07 + 0x0f) / 0x10, (0x02 * 0x08 + 0x0f) / 0x10, (0x02 * 0x09 + 0x0f) / 0x10, (0x02 * 0x0a + 0x0f) / 0x10, (0x02 * 0x0b + 0x0f) / 0x10, (0x02 * 0x0c + 0x0f) / 0x10, (0x02 * 0x0d + 0x0f) / 0x10, (0x02 * 0x0e + 0x0f) / 0x10, (0x02 * 0x0f + 0x0f) / 0x10, (0x02 * 0x10 + 0x0f) / 0x10
    .db     (0x03 * 0x01 + 0x0f) / 0x10, (0x03 * 0x02 + 0x0f) / 0x10, (0x03 * 0x03 + 0x0f) / 0x10, (0x03 * 0x04 + 0x0f) / 0x10, (0x03 * 0x05 + 0x0f) / 0x10, (0x03 * 0x06 + 0x0f) / 0x10, (0x03 * 0x07 + 0x0f) / 0x10, (0x03 * 0x08 + 0x0f) / 0x10, (0x03 * 0x09 + 0x0f) / 0x10, (0x03 * 0x0a + 0x0f) / 0x10, (0x03 * 0x0b + 0x0f) / 0x10, (0x03 * 0x0c + 0x0f) / 0x10, (0x03 * 0x0d + 0x0f) / 0x10, (0x03 * 0x0e + 0x0f) / 0x10, (0x03 * 0x0f + 0x0f) / 0x10, (0x03 * 0x10 + 0x0f) / 0x10
    .db     (0x04 * 0x01 + 0x0f) / 0x10, (0x04 * 0x02 + 0x0f) / 0x10, (0x04 * 0x03 + 0x0f) / 0x10, (0x04 * 0x04 + 0x0f) / 0x10, (0x04 * 0x05 + 0x0f) / 0x10, (0x04 * 0x06 + 0x0f) / 0x10, (0x04 * 0x07 + 0x0f) / 0x10, (0x04 * 0x08 + 0x0f) / 0x10, (0x04 * 0x09 + 0x0f) / 0x10, (0x04 * 0x0a + 0x0f) / 0x10, (0x04 * 0x0b + 0x0f) / 0x10, (0x04 * 0x0c + 0x0f) / 0x10, (0x04 * 0x0d + 0x0f) / 0x10, (0x04 * 0x0e + 0x0f) / 0x10, (0x04 * 0x0f + 0x0f) / 0x10, (0x04 * 0x10 + 0x0f) / 0x10
    .db     (0x05 * 0x01 + 0x0f) / 0x10, (0x05 * 0x02 + 0x0f) / 0x10, (0x05 * 0x03 + 0x0f) / 0x10, (0x05 * 0x04 + 0x0f) / 0x10, (0x05 * 0x05 + 0x0f) / 0x10, (0x05 * 0x06 + 0x0f) / 0x10, (0x05 * 0x07 + 0x0f) / 0x10, (0x05 * 0x08 + 0x0f) / 0x10, (0x05 * 0x09 + 0x0f) / 0x10, (0x05 * 0x0a + 0x0f) / 0x10, (0x05 * 0x0b + 0x0f) / 0x10, (0x05 * 0x0c + 0x0f) / 0x10, (0x05 * 0x0d + 0x0f) / 0x10, (0x05 * 0x0e + 0x0f) / 0x10, (0x05 * 0x0f + 0x0f) / 0x10, (0x05 * 0x10 + 0x0f) / 0x10
    .db     (0x06 * 0x01 + 0x0f) / 0x10, (0x06 * 0x02 + 0x0f) / 0x10, (0x06 * 0x03 + 0x0f) / 0x10, (0x06 * 0x04 + 0x0f) / 0x10, (0x06 * 0x05 + 0x0f) / 0x10, (0x06 * 0x06 + 0x0f) / 0x10, (0x06 * 0x07 + 0x0f) / 0x10, (0x06 * 0x08 + 0x0f) / 0x10, (0x06 * 0x09 + 0x0f) / 0x10, (0x06 * 0x0a + 0x0f) / 0x10, (0x06 * 0x0b + 0x0f) / 0x10, (0x06 * 0x0c + 0x0f) / 0x10, (0x06 * 0x0d + 0x0f) / 0x10, (0x06 * 0x0e + 0x0f) / 0x10, (0x06 * 0x0f + 0x0f) / 0x10, (0x06 * 0x10 + 0x0f) / 0x10
    .db     (0x07 * 0x01 + 0x0f) / 0x10, (0x07 * 0x02 + 0x0f) / 0x10, (0x07 * 0x03 + 0x0f) / 0x10, (0x07 * 0x04 + 0x0f) / 0x10, (0x07 * 0x05 + 0x0f) / 0x10, (0x07 * 0x06 + 0x0f) / 0x10, (0x07 * 0x07 + 0x0f) / 0x10, (0x07 * 0x08 + 0x0f) / 0x10, (0x07 * 0x09 + 0x0f) / 0x10, (0x07 * 0x0a + 0x0f) / 0x10, (0x07 * 0x0b + 0x0f) / 0x10, (0x07 * 0x0c + 0x0f) / 0x10, (0x07 * 0x0d + 0x0f) / 0x10, (0x07 * 0x0e + 0x0f) / 0x10, (0x07 * 0x0f + 0x0f) / 0x10, (0x07 * 0x10 + 0x0f) / 0x10
    .db     (0x08 * 0x01 + 0x0f) / 0x10, (0x08 * 0x02 + 0x0f) / 0x10, (0x08 * 0x03 + 0x0f) / 0x10, (0x08 * 0x04 + 0x0f) / 0x10, (0x08 * 0x05 + 0x0f) / 0x10, (0x08 * 0x06 + 0x0f) / 0x10, (0x08 * 0x07 + 0x0f) / 0x10, (0x08 * 0x08 + 0x0f) / 0x10, (0x08 * 0x09 + 0x0f) / 0x10, (0x08 * 0x0a + 0x0f) / 0x10, (0x08 * 0x0b + 0x0f) / 0x10, (0x08 * 0x0c + 0x0f) / 0x10, (0x08 * 0x0d + 0x0f) / 0x10, (0x08 * 0x0e + 0x0f) / 0x10, (0x08 * 0x0f + 0x0f) / 0x10, (0x08 * 0x10 + 0x0f) / 0x10
    .db     (0x09 * 0x01 + 0x0f) / 0x10, (0x09 * 0x02 + 0x0f) / 0x10, (0x09 * 0x03 + 0x0f) / 0x10, (0x09 * 0x04 + 0x0f) / 0x10, (0x09 * 0x05 + 0x0f) / 0x10, (0x09 * 0x06 + 0x0f) / 0x10, (0x09 * 0x07 + 0x0f) / 0x10, (0x09 * 0x08 + 0x0f) / 0x10, (0x09 * 0x09 + 0x0f) / 0x10, (0x09 * 0x0a + 0x0f) / 0x10, (0x09 * 0x0b + 0x0f) / 0x10, (0x09 * 0x0c + 0x0f) / 0x10, (0x09 * 0x0d + 0x0f) / 0x10, (0x09 * 0x0e + 0x0f) / 0x10, (0x09 * 0x0f + 0x0f) / 0x10, (0x09 * 0x10 + 0x0f) / 0x10
    .db     (0x0a * 0x01 + 0x0f) / 0x10, (0x0a * 0x02 + 0x0f) / 0x10, (0x0a * 0x03 + 0x0f) / 0x10, (0x0a * 0x04 + 0x0f) / 0x10, (0x0a * 0x05 + 0x0f) / 0x10, (0x0a * 0x06 + 0x0f) / 0x10, (0x0a * 0x07 + 0x0f) / 0x10, (0x0a * 0x08 + 0x0f) / 0x10, (0x0a * 0x09 + 0x0f) / 0x10, (0x0a * 0x0a + 0x0f) / 0x10, (0x0a * 0x0b + 0x0f) / 0x10, (0x0a * 0x0c + 0x0f) / 0x10, (0x0a * 0x0d + 0x0f) / 0x10, (0x0a * 0x0e + 0x0f) / 0x10, (0x0a * 0x0f + 0x0f) / 0x10, (0x0a * 0x10 + 0x0f) / 0x10
    .db     (0x0b * 0x01 + 0x0f) / 0x10, (0x0b * 0x02 + 0x0f) / 0x10, (0x0b * 0x03 + 0x0f) / 0x10, (0x0b * 0x04 + 0x0f) / 0x10, (0x0b * 0x05 + 0x0f) / 0x10, (0x0b * 0x06 + 0x0f) / 0x10, (0x0b * 0x07 + 0x0f) / 0x10, (0x0b * 0x08 + 0x0f) / 0x10, (0x0b * 0x09 + 0x0f) / 0x10, (0x0b * 0x0a + 0x0f) / 0x10, (0x0b * 0x0b + 0x0f) / 0x10, (0x0b * 0x0c + 0x0f) / 0x10, (0x0b * 0x0d + 0x0f) / 0x10, (0x0b * 0x0e + 0x0f) / 0x10, (0x0b * 0x0f + 0x0f) / 0x10, (0x0b * 0x10 + 0x0f) / 0x10
    .db     (0x0c * 0x01 + 0x0f) / 0x10, (0x0c * 0x02 + 0x0f) / 0x10, (0x0c * 0x03 + 0x0f) / 0x10, (0x0c * 0x04 + 0x0f) / 0x10, (0x0c * 0x05 + 0x0f) / 0x10, (0x0c * 0x06 + 0x0f) / 0x10, (0x0c * 0x07 + 0x0f) / 0x10, (0x0c * 0x08 + 0x0f) / 0x10, (0x0c * 0x09 + 0x0f) / 0x10, (0x0c * 0x0a + 0x0f) / 0x10, (0x0c * 0x0b + 0x0f) / 0x10, (0x0c * 0x0c + 0x0f) / 0x10, (0x0c * 0x0d + 0x0f) / 0x10, (0x0c * 0x0e + 0x0f) / 0x10, (0x0c * 0x0f + 0x0f) / 0x10, (0x0c * 0x10 + 0x0f) / 0x10
    .db     (0x0d * 0x01 + 0x0f) / 0x10, (0x0d * 0x02 + 0x0f) / 0x10, (0x0d * 0x03 + 0x0f) / 0x10, (0x0d * 0x04 + 0x0f) / 0x10, (0x0d * 0x05 + 0x0f) / 0x10, (0x0d * 0x06 + 0x0f) / 0x10, (0x0d * 0x07 + 0x0f) / 0x10, (0x0d * 0x08 + 0x0f) / 0x10, (0x0d * 0x09 + 0x0f) / 0x10, (0x0d * 0x0a + 0x0f) / 0x10, (0x0d * 0x0b + 0x0f) / 0x10, (0x0d * 0x0c + 0x0f) / 0x10, (0x0d * 0x0d + 0x0f) / 0x10, (0x0d * 0x0e + 0x0f) / 0x10, (0x0d * 0x0f + 0x0f) / 0x10, (0x0d * 0x10 + 0x0f) / 0x10
    .db     (0x0e * 0x01 + 0x0f) / 0x10, (0x0e * 0x02 + 0x0f) / 0x10, (0x0e * 0x03 + 0x0f) / 0x10, (0x0e * 0x04 + 0x0f) / 0x10, (0x0e * 0x05 + 0x0f) / 0x10, (0x0e * 0x06 + 0x0f) / 0x10, (0x0e * 0x07 + 0x0f) / 0x10, (0x0e * 0x08 + 0x0f) / 0x10, (0x0e * 0x09 + 0x0f) / 0x10, (0x0e * 0x0a + 0x0f) / 0x10, (0x0e * 0x0b + 0x0f) / 0x10, (0x0e * 0x0c + 0x0f) / 0x10, (0x0e * 0x0d + 0x0f) / 0x10, (0x0e * 0x0e + 0x0f) / 0x10, (0x0e * 0x0f + 0x0f) / 0x10, (0x0e * 0x10 + 0x0f) / 0x10
    .db     (0x0f * 0x01 + 0x0f) / 0x10, (0x0f * 0x02 + 0x0f) / 0x10, (0x0f * 0x03 + 0x0f) / 0x10, (0x0f * 0x04 + 0x0f) / 0x10, (0x0f * 0x05 + 0x0f) / 0x10, (0x0f * 0x06 + 0x0f) / 0x10, (0x0f * 0x07 + 0x0f) / 0x10, (0x0f * 0x08 + 0x0f) / 0x10, (0x0f * 0x09 + 0x0f) / 0x10, (0x0f * 0x0a + 0x0f) / 0x10, (0x0f * 0x0b + 0x0f) / 0x10, (0x0f * 0x0c + 0x0f) / 0x10, (0x0f * 0x0d + 0x0f) / 0x10, (0x0f * 0x0e + 0x0f) / 0x10, (0x0f * 0x0f + 0x0f) / 0x10, (0x0f * 0x10 + 0x0f) / 0x10
    .db     (0x10 * 0x01 + 0x0f) / 0x10, (0x10 * 0x02 + 0x0f) / 0x10, (0x10 * 0x03 + 0x0f) / 0x10, (0x10 * 0x04 + 0x0f) / 0x10, (0x10 * 0x05 + 0x0f) / 0x10, (0x10 * 0x06 + 0x0f) / 0x10, (0x10 * 0x07 + 0x0f) / 0x10, (0x10 * 0x08 + 0x0f) / 0x10, (0x10 * 0x09 + 0x0f) / 0x10, (0x10 * 0x0a + 0x0f) / 0x10, (0x10 * 0x0b + 0x0f) / 0x10, (0x10 * 0x0c + 0x0f) / 0x10, (0x10 * 0x0d + 0x0f) / 0x10, (0x10 * 0x0e + 0x0f) / 0x10, (0x10 * 0x0f + 0x0f) / 0x10, (0x10 * 0x10 + 0x0f) / 0x10

; スプライト
;
ringSprite8:

    .db     -0x08 - 0x01, -0x08, 0x00, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x20, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x24, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x28, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x2c, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x30, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x34, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x38, VDP_COLOR_TRANSPARENT
    .db     -0x08 - 0x01, -0x08, 0x3c, VDP_COLOR_TRANSPARENT

ringSprite16:

    .db     -0x10 - 0x01,  0x00, 0x44, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x4c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x48, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x40, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0x54, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x5c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x58, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x50, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0x64, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x6c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x68, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x60, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0x74, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x7c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x78, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x70, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0x84, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x8c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x88, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x80, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0x94, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0x9c, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0x98, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0x90, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0xa4, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0xac, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0xa8, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0xa0, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01,  0x00, 0xb4, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01,  0x00, 0xbc, VDP_COLOR_TRANSPARENT
    .db      0x00 - 0x01, -0x10, 0xb8, VDP_COLOR_TRANSPARENT
    .db     -0x10 - 0x01, -0x10, 0xb0, VDP_COLOR_TRANSPARENT

; コリジョン
;
ringCollision:

    .db     0x01
    .db     0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08
    .db     0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10


; DATA 領域
;
    .area   _DATA

; 変数の定義
;

; フレーム
;
ringFrame:

    .ds     0x01

